#ifndef __CKnob__
#define __CKnob__

#include "CAnimation.hpp"
#include <MathTools/CBounds.hpp>

//	===========================================================================

using Exponent::GUI::Controls::CAnimation;
using Exponent::MathTools::CBounds;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @interface CKnob CKnob.hpp
			 * @brief An rotary knob
			 *
			 * @date 11/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CKnob.hpp,v 1.6 2007/02/08 21:07:54 paul Exp $
			 */
			class CKnob : public CAnimation
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================
		
			public:

//	===========================================================================

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 * @param listener The action listener
				 */
				CKnob(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener = NULL);

				/**
				 * Destruction
				 */
				virtual ~CKnob();

//	===========================================================================

				/**
				 * Handle left button being clicked
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonDown(CMouseEvent &event);

				/**
				 * Handle left button being released
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonUp(CMouseEvent &event);

				/**
				 * Handle a double click on the left button
				 * @param event The event to handle
				 */
				virtual void handleDoubleClick(CMouseEvent &event);

				/**
				 * Handle the scroll wheel
				 * @param event The event to handle
				 */
				virtual void handleMouseScroll(CMouseEvent &event);

				/**
				 * Handle the mouse movement
				 * @param event The event to handle
				 */
				virtual void handleMouseMovement(CMouseEvent &event);

//	===========================================================================

				/**
				 * Set the default value
				 * @param value The default value that is returned to on a double click
				 */
				virtual void setDefaultValue(const double value) { m_defaultValue = value; }

				/**
				 * Set the coefficient
				 * @param coefficient Changes to this value result infasteror slower knob movement. Good default is 0.005
				 */
				virtual void setDeltaCoefficient(const double coefficient) { m_coefficient = coefficient; }

//	===========================================================================

			protected:

//	===========================================================================

				double m_defaultValue;				/**< Default value */
				double m_dragStartValue;			/**< Starting drag value to determine move amount */
				double m_coefficient;				/**< Coefficient for movement */
				bool m_drag;						/**< Are we dragging */
				CPoint m_dragStartPoint;			/**< Where did they start click-dragging */
			};
		}
	}
}
#endif	// End of CKnob.hpp